/*
 * ALSA driver for Panasonic UniPhier series.
 * 
 * Copyright (c) 2013 Panasonic corporation.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/init.h>

#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/types.h>
#include <linux/spinlock.h>
#include <linux/vmalloc.h>
#include <linux/io.h>
#include <linux/fs.h>
#include <linux/fcntl.h>
#include <linux/sched.h>
#include <linux/signal.h>
#include <linux/wait.h>
#include <linux/poll.h>
#include <linux/kthread.h>
#include <linux/delay.h>
#include <linux/cdev.h>
#include <linux/proc_fs.h>
#include <linux/platform_device.h>

#include "mn2ws-pcm.h"

MODULE_AUTHOR("Katsuhiro Suzuki <suzuki.katsuhiro002@jp.panasonic.com>");
MODULE_DESCRIPTION("Panasonic UniPhier PCM Control Driver");
MODULE_LICENSE("GPL");

static int mn2ws_pcm_mixer_switch_info(struct snd_kcontrol *kcontrol, 
	struct snd_ctl_elem_info *uinfo);
static int mn2ws_pcm_mixer_volume_info(struct snd_kcontrol *kcontrol, 
	struct snd_ctl_elem_info *uinfo);
static int mn2ws_pcm_mixer_get(struct snd_kcontrol *kcontrol, 
	struct snd_ctl_elem_value *ucontrol);
static int mn2ws_pcm_mixer_put(struct snd_kcontrol *kcontrol, 
	struct snd_ctl_elem_value *ucontrol);

struct snd_kcontrol_new mn2ws_pcm_mixer_ops[] = {
	{
		.iface = SNDRV_CTL_ELEM_IFACE_MIXER, 
		.name = "PCM Playback Switch", 
		.index = 0, 
		.access = SNDRV_CTL_ELEM_ACCESS_READWRITE, 
		.private_value = 0xffff, 
		.info = mn2ws_pcm_mixer_switch_info,
		.get = mn2ws_pcm_mixer_get, 
		.put = mn2ws_pcm_mixer_put, 
	}, 
	{
		.iface = SNDRV_CTL_ELEM_IFACE_MIXER, 
		.name = "PCM Playback Volume", 
		.index = 0, 
		.access = SNDRV_CTL_ELEM_ACCESS_READWRITE, 
		.private_value = 0xffff, 
		.info = mn2ws_pcm_mixer_volume_info,
		.get = mn2ws_pcm_mixer_get, 
		.put = mn2ws_pcm_mixer_put, 
	}, 
	{
		.iface = SNDRV_CTL_ELEM_IFACE_MIXER, 
		.name = "DEC Playback Switch", 
		.index = 0, 
		.access = SNDRV_CTL_ELEM_ACCESS_READWRITE, 
		.private_value = 0xffff, 
		.info = mn2ws_pcm_mixer_switch_info,
		.get = mn2ws_pcm_mixer_get, 
		.put = mn2ws_pcm_mixer_put, 
	}, 
	{
		.iface = SNDRV_CTL_ELEM_IFACE_MIXER, 
		.name = "DEC Playback Volume", 
		.index = 0, 
		.access = SNDRV_CTL_ELEM_ACCESS_READWRITE, 
		.private_value = 0xffff, 
		.info = mn2ws_pcm_mixer_volume_info,
		.get = mn2ws_pcm_mixer_get, 
		.put = mn2ws_pcm_mixer_put, 
	}, 
	{
		.iface = SNDRV_CTL_ELEM_IFACE_MIXER, 
		.name = "PCM Redirect Capture Switch", 
		.index = 0, 
		.access = SNDRV_CTL_ELEM_ACCESS_READWRITE, 
		.private_value = 0xffff, 
		.info = mn2ws_pcm_mixer_switch_info,
		.get = mn2ws_pcm_mixer_get, 
		.put = mn2ws_pcm_mixer_put, 
	}, 
};
int mn2ws_pcm_mixer_num = ARRAY_SIZE(mn2ws_pcm_mixer_ops);

static int mn2ws_pcm_mixer_switch_info(struct snd_kcontrol *kcontrol, 
	struct snd_ctl_elem_info *uinfo)
{
	DPRINTF("%s\n", __func__);
	
	uinfo->type = SNDRV_CTL_ELEM_TYPE_BOOLEAN;
	uinfo->count = 2;
	uinfo->value.integer.min = 0;
	uinfo->value.integer.max = 1;
	
	return 0;
}

static int mn2ws_pcm_mixer_volume_info(struct snd_kcontrol *kcontrol, 
	struct snd_ctl_elem_info *uinfo)
{
	DPRINTF("%s\n", __func__);
	
	uinfo->type = SNDRV_CTL_ELEM_TYPE_INTEGER;
	uinfo->count = 2;
	uinfo->value.integer.min = 0;
	uinfo->value.integer.max = 100;
	
	return 0;
}

static int mn2ws_pcm_mixer_get(struct snd_kcontrol *kcontrol, 
	struct snd_ctl_elem_value *ucontrol)
{
	DPRINTF("%s\n", __func__);
	
	//FIXME: do nothing
	
	return 0;
}

static int mn2ws_pcm_mixer_put(struct snd_kcontrol *kcontrol, 
	struct snd_ctl_elem_value *ucontrol)
{
	DPRINTF("%s\n", __func__);
	
	//FIXME: do nothing
	
	DPRINTF("%s: %3ld %3ld %3ld %3ld : %3ld %3ld %3ld %3ld\n", 
		__func__, 
		ucontrol->value.integer.value[0], 
		ucontrol->value.integer.value[1], 
		ucontrol->value.integer.value[2], 
		ucontrol->value.integer.value[3], 
		ucontrol->value.integer.value[4], 
		ucontrol->value.integer.value[5], 
		ucontrol->value.integer.value[6], 
		ucontrol->value.integer.value[7]);
	
	return 0;
}
